function [valErrors, allInputs] = EOFPruning(nMonteCarlo, maxRounds, maxeof)

% Insert description here!



valErrors = ones(nMonteCarlo, maxRounds, maxeof-1) * inf;
allInputs = zeros(maxRounds, maxeof);


%% Learning part
for round = 1:maxRounds
  tic
  disp(['Calculation round ' num2str(round) ' of ' num2str(maxRounds)]);
  
  for mc = 1:nMonteCarlo
    if round == 1
      eval(['global dataMC' num2str(mc) ' valData' num2str(mc) ' valIndex' ...
        num2str(mc) ' allMissing' num2str(mc)]);
    else
      % When first round is done and the singular matrixes need updating
      [aa, bb] = min(squeeze(mean(valErrors(:, round-1, :),1)));
      index = sort(allInputs(round-1, 1:bb));
      index(index == 0) = [];
      eval(['temp = U' num2str(mc) '(:,index) * eigenValues' ...
        num2str(mc) '(index,index) * transpose(V' num2str(mc) ...
        '(:,index));']);
      
      eval(['dataMC' num2str(mc) '(allMissing' num2str(mc) ...
        ') = temp(allMissing' num2str(mc) ');']);
    end % If round
    
    % EOF procedure starts
    eval(['[U' num2str(mc) ', eigenValues' num2str(mc) ', V' ...
      num2str(mc) '] = svds(dataMC' num2str(mc) ', maxeof);']);
  end % For-loop mc
  
  % EOF with Forward Selection
  indexOut = [];
  indexLeft = 1:maxeof;
  
  for in = 1:maxeof-1
    errors = ones(nMonteCarlo, length(indexLeft)) * inf;
    
    for test = 1:length(indexLeft)
      indexTest = [indexOut indexLeft(test)];
      
      for mc = 1:nMonteCarlo
        eval(['valIndex = valIndex' num2str(mc) ';']);
        eval(['valData = valData' num2str(mc) ';']);
        
        % EOF Pruning
        eval(['output = U' num2str(mc) ...
          '(:,indexTest) * eigenValues' ...
          num2str(mc) '(indexTest,indexTest) * transpose(V' ...
          num2str(mc) '(:,indexTest));']);
        
        errors(mc, test) = mean((valData - output(valIndex)) .^2);
      end % For-loop mc
    end % For-loop test
    
    [aa, bb] = min(mean(errors, 1));
    valErrors(:, round, in) = errors(:,bb(1));
    indexOut = [indexOut indexLeft(bb(1))];
    indexLeft(bb(1)) = [];
  end % For-loop in
  
  % Final result of input selection
  allInputs(round, :) = [indexOut indexLeft];
  toc
end % For-loop round

