function [outputs] = ...
  SOM(dataLearn, indexVal, gridSizes, varargin)

% Finding missing values of a matrix using SOM
% Usage:
% fillings = SOM(data, missing, gridSizes, [SOM parameters]);
%
% data        2-D matrix with missing values
% missing     Selection of missing values to be returned, for example if
%             only filled validation set values are needed.
% gridSizes   Vector of grid sizes to be tested. Can be only one grid size or
%             any amount of grid sizes. Minimum is 2. The number refers to the
%             size of the square SOM lattice. For example, grid size 4 means a
%             square SOM lattice of size 4x4.
% 
% After the mandatory input arguments, all the rest are considered input
% arguments to the SOM algorithm. FOr more information about the SOM arguments,
% check som_make function description.
%
% The output of the function includes the locations defined in missing for
% all tested SOM grid sizes.

if strncmp('somtoolbox',path,length('somtoolbox')) == 0
  try
    addpath('somtoolbox');
  catch
    disp('Cannot find somtoolbox!');
    outputs = [];
    return;
  end
end

gridSizes(gridSizes < 2) = 2;

outputs = ones(max(gridSizes), length(indexVal)) * Inf;

for i = 1:length(gridSizes)
  if nargin == 3
    sMap = som_make(dataLearn, 'msize', [gridSizes(i) gridSizes(i)]);
  else
    sMap = ...
      som_make(dataLearn, 'msize', [gridSizes(i) gridSizes(i)], varargin{:});
  end
  
  bmus = som_bmus(sMap, dataLearn);
  filledData = sMap.codebook(bmus,:);
  outputs(gridSizes(i),:) = filledData(indexVal);
end

