//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: NodeFactory.cc 7 2006-10-26 10:26:41Z ah $

#include "config.h"
#ifdef WITH_PYTHON
#include <Python.h>
#define __PYTHON_H_INCLUDED__
#endif

#include "Templates.h"
#include "Node.h"
#include "NodeFactory.h"

Constant *NodeFactory::GetConstant(Label label, double v) const
{
  return new Constant(net, label, v);
}

ConstantV *NodeFactory::GetConstantV(Label label, DV v) const
{
  return new ConstantV(net, label, v);
}

Rectification *NodeFactory::GetRectification(Label label, Node *n) const
{
  return new Rectification(net, label, n);
}

RectificationV *NodeFactory::GetRectificationV(Label label, Node *n) const
{
  return new RectificationV(net, label, n);
}

Prod *NodeFactory::GetProd(Label label, Node *n1, Node *n2) const
{
  return new Prod(net, label, n1, n2);
}

ProdV *NodeFactory::GetProdV(Label label, Node *n1, Node *n2) const
{
  return new ProdV(net, label, n1, n2);
}

Sum2 *NodeFactory::GetSum2(Label label, Node *n1, Node *n2) const
{
  return new Sum2(net, label, n1, n2);
}

Sum2V *NodeFactory::GetSum2V(Label label, Node *n1, Node *n2) const
{
  return new Sum2V(net, label, n1, n2);
}

SumN *NodeFactory::GetSumN(Label label) const
{
  return new SumN(net, label);
}

SumNV *NodeFactory::GetSumNV(Label label) const
{
  return new SumNV(net, label);
}

Relay *NodeFactory::GetRelay(Label label, Node *n) const
{
  return new Relay(net, label, n);
}

Gaussian *NodeFactory::GetGaussian(Label label, Node *n1, Node *n2) const
{
  return new Gaussian(net, label, n1, n2);
}

GaussianV *NodeFactory::GetGaussianV(Label label, Node *n1, Node *n2) const
{
  return new GaussianV(net, label, n1, n2);
}

RectifiedGaussian *NodeFactory::GetRectifiedGaussian(Label label, Node *n1, Node *n2) const
{
  return new RectifiedGaussian(net, label, n1, n2);
}

RectifiedGaussianV *NodeFactory::GetRectifiedGaussianV(Label label, Node *n1, Node *n2) const
{
  return new RectifiedGaussianV(net, label, n1, n2);
}

GaussRect *NodeFactory::GetGaussRect(Label label, Node *n1, Node *n2) const
{
  return new GaussRect(net, label, n1, n2);
}

GaussRectV *NodeFactory::GetGaussRectV(Label label, Node *n1, Node *n2) const
{
  return new GaussRectV(net, label, n1, n2);
}


MoG *NodeFactory::GetMoG(Label label, Node *n) const
{
  return new MoG(net, label, n);
}

MoGV *NodeFactory::GetMoGV(Label label, Node *n) const
{
  return new MoGV(net, label, n);
}


DelayV *NodeFactory::GetDelayV(Label label, Node *n1, Node *n2) const
{
  return new DelayV(net, label, n1, n2);
}

SparseGaussV *NodeFactory::GetSparseGaussV(Label label, Node *n1, Node *n2) const
{
  return new SparseGaussV(net, label, n1, n2);
}

DelayGaussV *NodeFactory::GetDelayGaussV(Label label, Node *n1, Node *n2, Node *n3, Node *n4, Node *n5) const
{
  return new DelayGaussV(net, label, n1, n2, n3, n4, n5);
}

GaussNonlin *NodeFactory::GetGaussNonlin(Label label, Node *n1, Node *n2) const
{
  return new GaussNonlin(net, label, n1, n2);
}

GaussNonlinV *NodeFactory::GetGaussNonlinV(Label label, Node *n1, Node *n2) const
{
  return new GaussNonlinV(net, label, n1, n2);
}


Discrete *NodeFactory::GetDiscrete(Label label) const
{
  return new Discrete(net, label);
}

DiscreteV *NodeFactory::GetDiscreteV(Label label) const
{
  return new DiscreteV(net, label);
}

DiscreteDirichlet *NodeFactory::GetDiscreteDirichlet(Label label, 
						     Dirichlet *d) const
{
  return new DiscreteDirichlet(net, label, d);
}

DiscreteDirichletV *NodeFactory::GetDiscreteDirichletV(Label label, 
						       Dirichlet *d) const
{
  return new DiscreteDirichletV(net, label, d);
}


Dirichlet *NodeFactory::GetDirichlet(Label label, ConstantV *c) const
{
  return new Dirichlet(net, label, c);
}


Memory *NodeFactory::GetMemory(Label label, Node *n) const
{
  return new Memory(net, label, n);
}

OLDelayS *NodeFactory::GetOLDelayS(Label label, Node *n1, Node *n2) const
{
  return new OLDelayS(net, label, n1, n2);
}

OLDelayD *NodeFactory::GetOLDelayD(Label label, Node *n1, Node *n2) const
{
  return new OLDelayD(net, label, n1, n2);
}

Proxy *NodeFactory::GetProxy(Label label, Label rlabel) const
{
  return new Proxy(net, label, rlabel);
}

Evidence *NodeFactory::GetEvidence(Label label, Node *n) const
{
  return new Evidence(net, label, n);
}

EvidenceV *NodeFactory::GetEvidenceV(Label label, Node *n) const
{
  return new EvidenceV(net, label, n);
}


Net *NodeFactory::GetNet() const
{
  return net;
}
