//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: SpecFun.h 5 2006-10-26 09:44:54Z ah $

#ifndef SPECFUN_H
#define SPECFUN_H

class ValueException { };

inline double Sqr(double x) {
  return x * x;
}

#ifndef BAD_MATHLIB
inline double Erf(double x) {
  return erf(x);
}

inline double Erfc(double x) {
  return erfc(x);
}

inline double LogGamma(double x) {
  return lgamma(x);
}
#else
#include <float.h>

double Erf(double x);
double Erfc(double x);
double LogGamma(double x);

inline int finite(double x) {
  return _finite(x);
}
#endif

inline double Erfcx(double x) {
  return exp(x*x) * Erfc(x);
}

double NormPdf(double x, double m, double v);

double DiGamma(double x);

#endif
