# -*- coding: iso-8859-1 -*-

#
# This file is a part of the Bayes Blocks library
#
# Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
# Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License (included in file License.txt in the
# program package) for more details.
#
# $Id: PickleHelpers.py 7 2006-10-26 10:26:41Z ah $
#

NUMPYHACK=0

import cPickle
import os
import gzip
import random
try:
    import Numeric
except:
    try:
	import numpy.oldnumeric
    except:
	pass
    else:
	NUMPYHACK=1

def _ownopen(filename, mode='rb', bufsize=-1, checkgz=0):
    isread = 0
    for c in mode:
        if c == 'r':
            isread = 1
    if filename == "-":
        if isread:
            return sys.stdin
        else:
            return sys.stdout
    elif filename[-3:] == ".gz":
        return gzip.open(filename, mode, bufsize)
    elif ((not os.path.isfile(filename)) and checkgz and
          os.path.isfile(filename + ".gz")):
        return gzip.open(filename + ".gz", mode, bufsize)
    else:
        return open(filename, mode, bufsize)

def SaveWithPickle(obj, outfile, bin=1):
    """SaveWithPickle(obj, outfile, bin=1)

    Saves obj with Pickle to outfile, using binary format unless
    bin=0.  The output file will be gzipped if its name ends in .gz."""
    f = _ownopen(outfile, 'wb')
    cPickle.dump(obj, f, bin)
    f.close()

def LoadWithPickle(file):
    """LoadWithPickle(file)

    Restore the object saved in Pickle file "file".
    Gzipped files are handled transparently."""
    f = _ownopen(file, 'rb',checkgz=1)
    net = cPickle.load(f)
    f.close()
    return net

load = LoadWithPickle
save = SaveWithPickle

class _wrap_Random(random.Random):
    def __setstate__(self, state):
        if state[0] != random.Random().VERSION:
            print 'Incompatible random.Random state cannot be restored, falling back to random state'
        else:
            super(random.Random, self).setstate(state[1])
        self.__class__ = random.Random

def _find_global(modname, cls):
    if modname == 'random' and cls == 'Random':
        return _wrap_Random

    if NUMPYHACK and modname in ['MLab', 'Numeric'] and cls == 'array_constructor':
	return numpy.oldnumeric.array_constructor

    try:
        mod = __import__(modname, {}, {}, [cls,])
    except:
        try:
            mod = __import__('bblocks.' + modname, {}, {}, [cls,])
        except:
            try:
                mod = __import__('bblocks.examples.' + modname, {}, {}, [cls,])
            except:
                try:
                    mod = __import__('bblocks.examples.vm.' + modname, {}, {}, [cls,])
                except:
                    raise "Module %s class %s not found" % (modname, cls)
    return getattr(mod, cls)

def load_compat(file):
    """load_compat(file)

    Restore the object saved in Pickle file "file" saved with old module
    structure. Gzipped files are handled transparently."""
    f = _ownopen(file, 'rb', checkgz=1)
    up = cPickle.Unpickler(f)
    up.find_global = _find_global
    net = up.load()
    f.close()
    return net

class Pickleable:
    """A class that can be pickled."""
    def SaveWithPickle(self, outfile):
        """SaveWithPickle(self, outfile)

        Saves the class instanse with Pickle to outfile using the
        binary format.  The output file will be gzipped if its name
        ends in .gz."""
        SaveWithPickle(self, outfile)
