//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: Decay.cc 7 2006-10-26 10:26:41Z ah $

#include "config.h"
#ifdef WITH_PYTHON
#include <Python.h>
#define __PYTHON_H_INCLUDED__
#endif

#include "Decay.h"
#include "Net.h"
#include <stdexcept>

Decayer::Decayer(Net *net, NetLoader *loader)
{
  string s;
  decay_net = net;

  loader->StartEnumCont("decay_hooks");
  while (loader->GetString(s)) {
    decay_hooks.insert(s);
    decay_net->RegisterDecay(this, s);
  }
  loader->FinishEnumCont("decay_hooks");
}

Decayer::~Decayer()
{
  UnregisterFromAllHooks();
}

void Decayer::Save(NetSaver *saver)
{
  std::set<string>::iterator i;

  saver->StartEnumCont(decay_hooks.size(), "decay_hooks");
  for (i = decay_hooks.begin(); i != decay_hooks.end(); i++)
    saver->SetString(*i);
  saver->FinishEnumCont("decay_hooks");
}

void Decayer::UnregisterFromAllHooks()
{
  std::set<string>::iterator i;
  size_t last_size=decay_hooks.size();

  while (last_size > 0) {
    i = decay_hooks.begin();
    // UnregisterDecayFromHook removes the current entry from decay_hooks
    decay_net->UnregisterDecayFromHook(this, *i);
    if (decay_hooks.size()>=last_size)
      throw std::runtime_error("Size of decay_hooks didn't decrease as expected.");
    last_size=decay_hooks.size();
  }
}
