// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: DecayCounter.h 5 2006-10-26 09:44:54Z ah $

#ifndef DECAYCOUNTER_H
#define DECAYCOUNTER_H

#include "Templates.h"
#include "Saver.h"
#include "Loader.h"

class DecayCounter
{
public:
  static DecayCounter *GlobalLoader(NetLoader *loader);
  virtual ~DecayCounter() {}
  virtual void Load(NetLoader *loader) = 0;
  virtual void Save(NetSaver *saver) = 0;

  virtual double StepTime() = 0;
  virtual double GetDecay() = 0;
};

class TraditionalDecayCounter : public DecayCounter
{
public:
  TraditionalDecayCounter(double r = 0.5);

  virtual void Save(NetSaver *saver);
  virtual void Load(NetLoader *loader);

  virtual double StepTime();
  virtual double GetDecay() { return decay; }

  double samples, cumsum, ratio, decay;
};

#ifdef WITH_PYTHON
#ifndef __PYTHON_H_INCLUDED__
#error "Python.h must be included before this file.  (It must also be included before any system include files.)"
#endif // not __PYTHON_H_INCLUDED

class PythonDecayCounter : public DecayCounter
{
public:
  PythonDecayCounter(PyObject *step_function);
  virtual ~PythonDecayCounter();

  virtual void Save(NetSaver *saver);
  virtual void Load(NetLoader *loader);

  virtual double StepTime();
  virtual double GetDecay() { return decay; }

  double decay;
  PyObject *step_function;
};
#endif  // WITH_PYTHON

#endif // DECAYCOUNTER_H
