//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: XMLSaver.cc 5 2006-10-26 09:44:54Z ah $

#include "XMLSaver.h"

XMLSaver::XMLSaver(string filename)
{
  fp = new ofstream(filename.c_str());
}


void XMLSaver::DumpDFlags(const DFlags f)
{
  *fp << "<DFlags>" << endl <<
    "  mean = " << f.mean << endl <<
    "  var  = " << f.var << endl <<
    "  ex   = " << f.ex << endl <<
    "</DFlags>" << endl;
}

void XMLSaver::DumpDSSet(const DSSet f)
{
  *fp << "<DSSet>" << endl <<
    "  mean = " << f.mean << endl <<
    "  var  = " << f.var << endl <<
    "  ex   = " << f.ex << endl <<
    "</DSSet>" << endl;
}

void XMLSaver::DumpDV(const DV f)
{
  for (size_t i = 0; i < f.size(); i++) {
    *fp << f[i] << ' ';
  }
  *fp << endl;
}

void XMLSaver::DumpDVSet(const DVSet f)
{
  *fp << "<DVSet>" << endl <<
    "  <mean>" << endl;
  DumpDV(f.mean);
  *fp << "  </mean>" << endl << "  <var>" << endl;
  DumpDV(f.var);
  *fp << "  </var>" << endl << "  <ex>" << endl;
  DumpDV(f.ex);
  *fp << "  </ex>" << endl;
}

void XMLSaver::DumpDVH(const DVH f)
{
  *fp << "<DVH>" << endl <<
    "  <scalar>" << endl;
  DumpDSSet(f.scalar);
  *fp << "  </scalar>" << endl;
  if(f.vec) {
    *fp << "  <vec>" << endl;
    DumpDVSet(*f.vec);
    *fp << "  </vec>" << endl;
  }
}

void XMLSaver::DumpDD(const DD f)
{
  *fp << "<DD>" << endl;
  DumpDV(*f.GetDV());
  *fp << "</DD>" << endl;
}

void XMLSaver::DumpVDD(const VDD f)
{
  *fp << "<VDD>" << endl;
  for (size_t i=0; i<f.size(); i++)
    DumpDD(f[i]);
  *fp << "</VDD>" << endl;
}

void XMLSaver::DumpIntV(const IntV f)
{
  for (size_t i = 0; i < f.size(); i++) {
    *fp << f[i] << ' ';
  }
  *fp << endl;
}

void XMLSaver::DumpString(string str)
{
  *fp << str << endl;
}
