// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: XMLSaver.h 5 2006-10-26 09:44:54Z ah $

#ifndef XMLSAVER_H
#define XMLSAVER_H

#include "Templates.h"
#include "Saver.h"
#include <fstream>

class XMLSaver : public ConcreteSaver
{
public:
  XMLSaver(string filename);
  virtual ~XMLSaver() {delete fp;}
  virtual void SaveIt() {fp->close();};

  virtual void StartEnumeratedContainer(int size, string name) {
    *fp << '<' << name << '>' << endl; }
  virtual void StartNamedContainer(string name) {
    *fp << '<' << name << '>' << endl; }
  virtual void CloseEnumeratedContainer(string name) {
    *fp << "</" << name << '>' << endl; }
  virtual void CloseNamedContainer(string name) {
    *fp << "</" << name << '>' << endl; }
  virtual void StartNode(string type) {
    *fp << '<' << type << '>' << endl; }
  virtual void CloseNode(string type) {
    *fp << "</" << type << '>' << endl; }
  virtual void SetDouble(double val) { *fp << val << endl; }
  virtual void SetInt(int val) { *fp << val << endl; }
  virtual void SetBool(bool val) { *fp << val << endl; }
  virtual void SetString(string val) { DumpString(val); }
  virtual void SetLabel(Label val) { DumpString(val); }
  virtual void SetDV(DV val) { DumpDV(val); }
  virtual void SetDFlags(DFlags val) { DumpDFlags(val); }
  virtual void SetDSSet(DSSet val) { DumpDSSet(val); }
  virtual void SetDVSet(DVSet val) { DumpDVSet(val); }
  virtual void SetDVH(DVH val) { DumpDVH(val); }
  virtual void SetDD(DD val) { DumpDD(val); }
  virtual void SetVDD(VDD val) { DumpVDD(val); }
  virtual void SetIntV(IntV val) { DumpIntV(val); }
  virtual void SetNamedDouble(string name, double val) {
    *fp << name << " = " << val << endl;
  }
  virtual void SetNamedInt(string name, int val) {
    *fp << name << " = " << val << endl;
  }
  virtual void SetNamedBool(string name, bool val) {
    *fp << name << " = " << val << endl;
  }
  virtual void SetNamedString(string name, string val) {
    *fp << name << " = " << val << endl;
  }
  virtual void SetNamedLabel(string name, Label val) {
    *fp << name << " = " << val << endl;
  }
  virtual void SetNamedDV(string name, DV val) {
    *fp << name << " = ";
    DumpDV(val);
  }
  virtual void SetNamedDFlags(string name, DFlags val) {
    *fp << name << " = ";
    DumpDFlags(val);
  }
  virtual void SetNamedDSSet(string name, DSSet val) {
    *fp << name << " = ";
    DumpDSSet(val);
  }
  virtual void SetNamedDVSet(string name, DVSet val) {
    *fp << name << " = ";
    DumpDVSet(val);
  }
  virtual void SetNamedDVH(string name, DVH val) {
    *fp << name << " = ";
    DumpDVH(val);
  }
  virtual void SetNamedDD(string name, DD val) {
    *fp << name << " = ";
    DumpDD(val);
  }
  virtual void SetNamedVDD(string name, VDD val) {
    *fp << name << " = ";
    DumpVDD(val);
  }
  virtual void SetNamedIntV(string name, IntV val) {
    *fp << name << " = ";
    DumpIntV(val);
  }

private:
  void DumpDFlags(const DFlags f);
  void DumpDSSet(const DSSet f);
  void DumpDV(const DV f);
  void DumpDVSet(const DVSet f);
  void DumpDVH(const DVH f);
  void DumpDD(const DD f);
  void DumpVDD(const VDD f);
  void DumpIntV(const IntV f);
  void DumpString(string str);

  ofstream *fp;
};

#endif // XMLSAVER_H
