% This script runs 7500 iterations of the NDFA algorithm on the Lorenz-data.
% Then it starts the script more_lorenz.m which runs the rest of the
% iterations.

%These values gave the best model in the long run.
searchsources = 9;
randseed = 0;

% In shorter runs the best models and the attained costs were:
%  #iter       cost        #sources     seed
%    7500:   445.008057       8          2
%   15000:  -653.171847       8          2 
%   30000: -1466.461724       9          1
%   60000: -2092.154264       9          1
%  125000: -2488.383767       9          3
%  250000: -2748.559470       9          3
%  500000: -2927.222731       9          0
% 1000000: -2949.246994       9          0
% The exact results depend on the platform.  It is very likely that
% you will find that other random seeds yield the best results.

%Add the NDFA-package to the path
addpath ndfa

%Number of hidden neurons in the mappings (thidden = the dynamic mapping)
hidneurons = 30;
thidneurons = 30;

load lorenzdata
filenam = sprintf('Lorenz_%d_%d', searchsources, randseed);

% Initialize the models and use embedded data.  The data components
% are normalized to zero mean.
fprintf('Initializing with embedded data (dimension is now %d).\n', ...
        size(data, 1))
[data, initsrc] = init_em(data, searchsources);

% Run the thing...
randn('state', randseed);
res = ndfa(data, 'initsources', initsrc, 'hidneurons', hidneurons, ...
	   'thidneurons', thidneurons, 'iters', 500);

% Drop off the time-lagged parts of the data and prune the network accordingly
data=data(21:30,:);
res.net.w2=res.net.w2(21:30,:);
res.net.b2=res.net.b2(21:30,:);
res.params.noise=res.params.noise(21:30);

fprintf('Extra parts of the data are left out (dimension is now %d).\n', ...
         size(data, 1))

save(filenam, 'res', 'data', 'filenam');
fprintf('File %s saved\n', filenam)

more_lorenz
