function c = kl_data(data, meanprior, varprior, dim)
% KL_DATA  Calculate the contribution of observations and their
%          reconstruction to the Kullback-Leibler divergence

% Copyright (C) 1999-2000 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if nargin < 4
  dim = 2;
end

effvar = normalvar(varprior);

c = ...
    .5 * log(2*pi) * prod(size(data.m)) + ...
    sum(varprior.m) * prod(size(data.m)) / prod(size(varprior.m)) + ...
    .5 * sum(sum((data.m - meanprior.m).^2 + ...
		  data.v + meanprior.v, dim) ./ effvar);
