function [newsources, newnet, newparams] = ...
    scalesources(sources, net, params)
% SCALESOURCES  Scale the sources so that variance of first layer
%   weights is equal to unity as assumed by their prior

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

scalefactors = sqrt(var(net.w1.m) + mean(net.w1.v));

newsources = sources;
newsources.m = diag(scalefactors) * sources.m;
newsources.v = diag(scalefactors.^2) * sources.v;
newnet = net;
newnet.w1.m = net.w1.m * diag(1 ./ scalefactors);
newnet.w1.v = net.w1.v * diag(1 ./ (scalefactors .^ 2));

newparams = params;
newparams.src.m = params.src.m + log(scalefactors');
[newparams.hyper.src.mean, newparams.hyper.src.var] = ...
    estimatemeanvars(newparams.src, newparams.prior.src.mean, ...
		     newparams.prior.src.var, newparams.hyper.src.var, 1);

newparams.src = estimatevars(sources, newparams.hyper.src, params.src);
%newparams.src = estimatevars(sources, params.hyper.src, params.src);
