function [net, params] = try_pruning_hidden_neuron(data, s, net0, params0, ind, status, diff)
% TRY_PRUNING_HIDDEN_NEURON  Try pruning the given hidden neuron
%
%     This function is easier to use through PRUNE_EVERYTHING.

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

I = setdiff(1:size(net0.w1.m, 1), ind);

net = net0;
net.w1.m = net.w1.m(I, :);
net.b1.m = net.b1.m(I, :);
net.w2.m = net.w2.m(:, I);
net.w1.v = net.w1.v(I, :);
net.b1.v = net.b1.v(I, :);
net.w2.v = net.w2.v(:, I);

params = params0;
params.net.w2var = params.net.w2var(:, I);

fs_tmp = feedfw(s, net, status.approximation);
c1 = kl_batch(fs_tmp{4}, s, data, params) + kl_static(net, params);

fs_tmp = feedfw(s, net0, status.approximation);
c0 = kl_batch(fs_tmp{4}, s, data, params0) + kl_static(net0, params0);

fprintf('Try pruning hidden neuron %d: oldc=%f, newc=%f\n', ind, c0, c1);

if (c1 - c0 < diff),
  fprintf('Pruning hidden neuron %d...\n', ind);
else
  net = net0;
  params = params0;
end
