%  CNT_DYNICA.M
%
%  cnt_dynica( datafile, initA, iter, nsave, diag_qs ) continues the
%  simulations started with RUN_DYNICA. The trained model is loaded
%  from the file created by RUN_DYNICA.
%
%  Examples:
%    cnt_dynica( 'dyn8_-8', 'PCA', 2000, 100, 0 )
%
function cnt_dynica( datafile, initA, iter, nsave, diag_qs )

if nargin < 5 | isempty(diag_qs)
    diag_qs = 0;
end

if diag_qs
    netfile = [ package_dir '/RESULTS/Diag_Qs/' datafile '__' initA ];
else
    netfile = [ package_dir '/RESULTS/Full_Qs/' datafile '__' initA ];
end


load( netfile, 'net', 'nit', 'CF' )
load( [ package_dir '/DATA/' datafile ], 'x' )
x = x';
status.iter = nit(end);
status.CF = CF;
status.diag_qs = diag_qs;

nnets = length(net);
itercomplete = nit(end);
for i = 1:ceil( (iter-itercomplete)/nsave )
    
    if itercomplete + i*nsave > iter
        nit(nnets+i) = iter;
    else
        nit(nnets+i) = itercomplete + i*nsave;
    end
    [ net{nnets+i}, status ] = dynica( x, nit(nnets+i),...
                                       net{nnets+i-1}, status );
    CF = status.CF;
    
    save( netfile, 'net', 'nit', '-append' )

end

disp( [ 'The results written to ' netfile ] )

