%  EXPLOG_PI.M
%
%  explog = explog_pi( c ) calculates the expected value of the
%  logarithm of a Dirichlet variable c, i.e. explog = < log c >.
%  
function explog = explog_pi( mog_pi )

verstr = version;
if verstr(1:4) == '6.5.'
    explog = psi( mog_pi.counts ) - psi( sum(mog_pi.counts) );
else
    explog = mfun( 'Psi', mog_pi.counts ) - ...
             mfun( 'Psi', sum(mog_pi.counts) );
end
