%  FA.M
%
%  The general linear factor analysis model: a noisy linear mixture of
%  Gaussian sources. The posterior of the sources is approximated by
%  the normal distribution with the full covariance matrix.
%
%  These experiments are not used in the paper but the code is the
%  starting point for the linear ICA models considered in the paper.
%
function fa

    %
    % Data
    %
datafile = 'dyn8_6.mat';
load( [ package_dir '/DATA/' datafile ], ...
      'A', 'Apca', 's', 'x' )
x_data = x';

Q = orth(A);
prA = Q';

switch 'ICA'
case 'ICA'
    A_init = A;
case 'PCA'
    A_init = Apca;
case 'random'
    A_init = rand( size(A) ) - 0.5;
end

clear A x

xdim = size(x_data,1);
tdim = size(x_data,2);
sdim = 2;

    %
    % Create and initialize variables
    %
s = repmat( struct( 'mean',  zeros(sdim,1),...
                    'covar', eye(sdim) ),...
            1, tdim );

A.mean = A_init;
A.var = ones( xdim, sdim );
A.clamped = 1;

for t = 1:tdim
    x(t).value = x_data(:,t);
end

vx.mean = zeros( xdim, 1 );
vx.var  = ones( xdim, 1 );
vx.mex  = meanexp( vx );

Mvx.mean = 0;
Mvx.var  = 1;

Vvx.mean = 0;
Vvx.var  = 1;
Vvx.mex  = meanexp( Vvx );

vs.mean = zeros( sdim, 1 );
vs.var  = ones( sdim, 1 );
vs.mex  = meanexp( vs );

Mvs.mean = 0;
Mvs.var  = 1;

Vvs.mean = 0;
Vvs.var  = 1;
Vvs.mex  = meanexp( Vvs );


    %
    % Learning
    %
n1 = 10; % Number of iterations with clamped A
n2 = 500; % Total number of iterations

for iter = 1:n2
    s = update_s( s, vs, A, vx, x );
    
    if ~A.clamped
        A = update_A( A, s, vx, x );
    end
    
    vx = update_vx( vx, Mvx, Vvx, x, A, s, 1 );
    Mvx = update_Mvx( Mvx, Vvx, vx );
    Vvx = update_Vvx( Vvx, Mvx, vx );
    
    vs = update_vs( vs, Mvs, Vvs, s );
    Mvs = update_Mvx( Mvs, Vvs, vs );
    Vvs = update_Vvx( Vvs, Mvs, vs );
    
    fprintf( 'Iteration %d\n', iter );

    if iter == n1
        A.clamped = 0;
    end

end

return
