function fcontour( fun, xpts, ypts, mode, varargin )

if nargin < 4 | isempty(mode)
    mode = 1;
end
    
[vx,vy] = meshgrid( xpts, ypts );
vz = zeros(size(vx));

switch mode
case 1
    for i = 1:size(vx,1)
        for j = 1:size(vx,2)
            vz(i,j) = feval( fun, vx(i,j), vy(i,j), varargin{:} );
        end
    end
case 2
    vz = feval( fun, vx, vy, varargin{:} );
case 3
    for i = 1:size(vx,1)
        for j = 1:size(vx,2)
            vz(i,j) = feval( fun, [vx(i,j); vy(i,j)], varargin{:} );
        end
    end
end


contour( vx, vy, vz )
