%  NET2DYNICA.M
%
%  Load variables of the ICA model with temporally correlated sources
%  from the given structure.
%
function [ A, s, vx, Vvx, Mvx,...
           B, vs, Mvs, Vvs, xnode ] = net2dynica( net, data )

tdim = length( net.s );

for t = 1:tdim
    s(t).mean = net.s(:,t);
    s(t).covar = net.s_covar(:,:,t);
end

A.mean = net.a;
A.var = net.a_var;

vx.mean = net.vx;
vx.var = net.vx_var;
vx.mex  = meanexp( vx );

Mvx.mean = net.mvx;
Mvx.var = net.mvx_var;

Vvx.mean = net.vvx;
Vvx.var = net.vvx_var;
Vvx.mex  = meanexp( Vvx );


B.mean = net.bs;
B.var = net.bs_var;

vs.mean = net.vs;
vs.var = net.vs_var;
vs.mex  = meanexp( vs );

Mvs.mean = net.mvs;
Mvs.var = net.mvs_var;

Vvs.mean = net.vvs;
Vvs.var = net.vvs_var;
Vvs.mex  = meanexp( Vvs );

if nargin >= 2 & ~isempty(data)
    if isstr(data)
        load( [ package_dir '/DATA/' data ], 'x' )
        for t = 1:tdim
            xnode(t).value = x(t,:);
        end
    else
        for t = 1:tdim
            xnode(t).value = data(:,t);
        end
    end
end

