%  NET2MOGICA.M
%
%  Load variables of the ICA model with the mixture-of-Gaussians model
%  for the sources from the given structure.
%
function [ A, s, vx, Vvx, Mvx,...
           Mmms, Vmms, Mvms, Vvms, Mmvs, Vmvs, Mvvs, Vvvs,...
           Mms, Vms, Mvs, Vvs,...
           ms, vs, mog_pi, lambda, xnode ] = net2mogica( net, data )


Mmms = net.Mmms;
Vmms = net.Vmms;
Mvms = net.Mvms;
Vvms = net.Vvms;

Mmvs = net.Mmvs;
Vmvs = net.Vmvs;
Mvvs = net.Mvvs;
Vvvs = net.Vvvs;

Mms = net.Mms;
Vms = net.Vms;
Mvs = net.Mvs;
Vvs = net.Vvs;
ms = net.ms;
vs = net.vs;
mog_pi = net.mog_pi;
lambda = net.lambda;

s = net.s_all;
A = net.A;

Mvx = net.Mvx;
Vvx = net.Vvx;
vx = net.vx;

tdim = length(s);

if nargin >= 2 & ~isempty(data)
    if isstr(data)
        load( [ package_dir '/DATA/' data ], 'x' )
        for t = 1:tdim
            xnode(t).value = x(t,:);
        end
    else
        for t = 1:tdim
            xnode(t).value = data(:,t);
        end
    end
end


return