%  NET2SGICA.M
%
%  Load variables of the ICA model with super-Gaussian sources from
%  the given structure.
%
function [ A, s, vx, Vvx, Mvx,...
           u, Mmu, Vmu, Mvu, Vvu, mu, vu,...
           xnode ] = net2sgica( net, data )

tdim = length( net.s );

for t = 1:tdim
    s(t).mean = net.s(:,t);
    s(t).covar = net.s_covar(:,:,t);
end

for t = 1:tdim
    u(t).mean = net.u(:,t);
    u(t).var = net.u_var(:,t);
    u(t).mex = meanexp(u(t));
end

A.mean = net.a;
A.var = net.a_var;

vx.mean = net.vx;
vx.var = net.vx_var;
vx.mex  = meanexp( vx );

Mvx.mean = net.mvx;
Mvx.var = net.mvx_var;

Vvx.mean = net.vvx;
Vvx.var = net.vvx_var;
Vvx.mex  = meanexp( Vvx );

Mmu.mean = net.Mmu;
Mmu.var = net.Mmu_var;

Vmu.mean = net.Vmu;
Vmu.var = net.Vmu_var;
Vmu.mex  = meanexp( Vmu );

Mvu.mean = net.Mvu;
Mvu.var = net.Mvu_var;
 
Vvu.mean = net.Vvu;
Vvu.var = net.Vvu_var;
Vvu.mex  = meanexp( Vvu );

mu.mean = net.mu;
mu.var = net.mu_var;

vu.mean = net.vu;
vu.var = net.vu_var;
vu.mex  = meanexp( vu );

if nargin >= 2 & ~isempty(data)
    if isstr(data)
        load( [ package_dir '/DATA/' data ], 'x' )
        for t = 1:tdim
            xnode(t).value = x(t,:);
        end
    else
        for t = 1:tdim
            xnode(t).value = data(:,t);
        end
    end
end

