%  PCA_TS.M
%
%  Principal Component Analysis.
%
%  [ y, W, lambda ] = pca_ts( x, a ) calculates the first a
%   principal vectors for the set of N observations:
%   x = [ x(1) x(2) ... x(N) ]
%
%   The columns of matrix W are the found principles vectors.
%
%   Matrix y contains the principal component values (the
%   projections onto the principal vectors).
%   Vector lambda is composed of the eigenvalues corresponding to
%   all the principal vectors.
%

%  Author:  Ilin A.N.
%
function [ y, W, lambda ] = pca_ts( x, a )

N = size(x,2);
mx = mean(x,2);
x = x - repmat(mx,1,N);

C = x*x'/N;
[ V, L ] = eig(C);

[ lambda, id ] = sort( -diag(L) );
lambda = -lambda;
V = V(:,id);

W = V( :, 1:a );
y = W'*x;

return