%  PLOT_DIR
%
%  PLOT_DIR( A ) plots the directions specified by the columns of A
%  in the current axes.
%
%  By defalut, the line is drawn such that it fits in the current
%  axes limits.
% 
%  PLOT_DIR( A, xlims, ylims ) specifies the limits of the line.
%
%  PLOT_DIR( A, xlims, ylims, 'PropertyName1', PropertyValue1 )
%  specifies properties of the line.
%
%  PLOT_DIR( A, 'PropertyName1', PropertyValue1 ) is also valid.
%
function h = plot_dir( A, varargin )

cur_xlims = get( gca, 'XLim' );
cur_ylims = get( gca, 'YLim' );

if nargin < 2 | isstr(varargin{1})
    xlims = cur_xlims;
    ylims = cur_ylims;
    
else % varargin{1} = xlims
    xlims = varargin{1};

    if nargin < 3 | isempty(varargin{2})
        ylims = cur_ylims;
    else
        ylims = varargin{2};
    end
    varargin = {varargin{3:end}};

end

hold on

for i = 1:size(A,2)
    
    %     A(2,i)
    % y = ------ x
    %     A(1,i)
    %
    if A(1,i) == 0
        h(i) = line( [ 0 0 ], ylims );
    
    elseif A(2,i) == 0
        h(i) = line( xlims, [ 0 0 ] );
    
    else
        x = xlims;
        y = A(2,i)/A(1,i) * xlims;
        
        if y(1) < ylims(1)
            y(1) = ylims(1);
            x(1) = A(1,i)/A(2,i) * y(1);
        elseif y(1) > ylims(2)
            y(1) = ylims(2);
            x(1) = A(1,i)/A(2,i) * y(1);
        end
        
        if y(2) < ylims(1)
            y(2) = ylims(1);
            x(2) = A(1,i)/A(2,i) * y(2);
        elseif y(2) > ylims(2)
            y(2) = ylims(2);
            x(2) = A(1,i)/A(2,i) * y(2);
        end
            
        h(i) = line( x, y );
    end
    
    if length(varargin) > 0
        set( h(i), varargin{:} )
    end
end

set( gca, 'XLim', cur_xlims, 'YLim', cur_ylims )

if nargout == 0
    clear h
end