%  PLOT_TRACK.M
%
%  Plot a track of two columns of the mixing matrix A in the subspace
%  of the true A during learning.
%
function h = plot_track( net, prA, A_2, Apca_2, track_ax, mksize )

if nargin < 6
    mksize = 7;
end

if nargin < 5 | isempty(track_ax)
    figure;
    
    set( gca, 'Box', 'On',...
              'NextPlot', 'Add',...
              'DrawMode', 'Fast' )
              %'XLim', [ -0.2 2.5 ],...
              %'YLim', [ -2.5 0.7 ] )
    axis equal
else
    axes( track_ax )
end

if isempty( track_ax )
    xlims = [ 0 0 ];
    ylims = [ 0 0 ];
else
    xlims = get( track_ax, 'XLim' );
    ylims = get( track_ax, 'YLim' );
end
for ix = 1:length(net)
    Ae_2 = prA*net{ix}.a;
    Ae1_2(:,ix) = Ae_2(:,1);
    Ae2_2(:,ix) = Ae_2(:,2);
    
    plot_vect( Ae_2, 'k:', 'MarkerSize', 5 );

    xlims(1) = min( [ xlims(1) Ae_2(1,:) ] );
    xlims(2) = max( [ xlims(2) Ae_2(1,:) ] );
    ylims(1) = min( [ ylims(1) Ae_2(2,:) ] );
    ylims(2) = max( [ ylims(2) Ae_2(2,:) ] );

end

h_track(1) = line( Ae1_2(1,:), Ae1_2(2,:) );
h_track(2) = line( Ae2_2(1,:), Ae2_2(2,:) );
set( h_track(1), 'Color', [ 0 0 0 ],...
                 'Marker', '.',...
                 'MarkerSize', mksize )
set( h_track(2), 'Color', [ 0 0 0 ],...
                 'Marker', '.',...
                 'MarkerSize', mksize )
plot_vect( Ae_2, 'ko', 'MarkerSize', mksize );

set( gca, 'XLim', xlims, 'YLim', ylims )
axis square

if nargout == 1
    h = gca;
end
return

