function h = pltvect( A, lstyle, varargin )

if nargin < 2
    lstyle = 'k-';
end

if ismember( '-', lstyle ) | ismember( ':', lstyle )
    for ix = 1:size(A,2)
        h(ix) = plot( [ 0 A(1,ix) ], [ 0 A(2,ix) ], lstyle );
        if length(varargin) > 1
            set( h(ix), varargin{:} )
        end
        hold on
    end
    
else
    if all( ~ismember( '.ox+*sdv^<>ph', lstyle ) )
        lstyle = [ lstyle '.' ];
    end
    h = plot( A(1,:), A(2,:), lstyle, 'MarkerSize', 1 );
    if length(varargin) > 1
        set( h, varargin{:} )
    end
end

if nargout == 0
    clear h
end