%  UPDATE_A.M
%
%  Linear factor analysis model. Update the posterior approximation for
%  the mixing matrix A.
%
function A = update_A( A, s, vx, x )

tdim = length(x);
[ xdim, sdim ] = size(A.mean);

for i = xdim:-1:1
    for j = sdim:-1:1
        
        %                                    N
        % L = <\alpha_j> + < exp{v_{x,i}} > sum < S_{t,j}^2 >
        %                                   t=1
        L = 0;
        for t = 1:tdim
            L = L + s(t).mean(j)^2 + s(t).covar(j,j);
        end
        L = 1 + vx.mex(i) * L;
        
        % ~a_{ij}~ = L^{-1}
        A.var(i,j) = inv(L);
        
        % ~a_{ij}~ <a_{ij}> = < exp{v_{x,i}} > *
        %      N
        %     sum { x_{t,i} < S_{t,j} > - 
        %     t=1
        %           sum < a_{ik} > < S_{t,k} S_{t,j} >
        %           k~=j
        k = [ 1:j-1 j+1:sdim ];
        M = 0;

        for t = 1:tdim
            M = M + x(t).value(i) * s(t).mean(j) - ...
                A.mean(i,k) * ...
                ( s(t).mean(j) * s(t).mean(k) + s(t).covar(k,j) );
        end
        A.mean(i,j) = A.var(i,j) * vx.mex(i) * M;
    end
end