%  UPDATE_MVX.M
%
%  Update the posterior approximation for the mean hyperparameter Mvx
%  of variance parameters vx. Mvx is the mean parent for all the
%  components of vx.
%
function Mvx = update_Mvx( Mvx, Vvx, vx )

xdim = length(vx.mean);

% From itself:
%   gme = < exp 0 > ( <Mvx> - <0> )
%   gva = 0.5 <exp 0>
%   gex = 0
gme = Mvx.mean;
gva = 0.5;
gex = 0;
    
% From children vx:
%          n
%   gme = sum <exp Vvx> ( <Mvx> - <vx_i> )
%         i=1
%
%          n
%   gva = sum 0.5 <exp Vvx>
%         i=1
%
%   gex = 0
%
gme = gme + Vvx.mex * sum( Mvx.mean - vx.mean );
gva = gva + xdim * 0.5 * Vvx.mex;

[Mvx.mean, Mvx.var] = var_newton( Mvx.mean, Mvx.var, gme, gva, gex );
