%  UPDATE_VMS.M
%
%  ICA with the mixture-of-Gaussians model for the sources. Update the
%  posterior approximation for the variance hyperparameter Vms of the
%  paramters ms. Mms is the variance parent for all the components of
%  ms. The components of ms are hyperparameter of the MoG prior for
%  different sources.
%
function Vms = update_Vms( Vms, Mvms, Vvms, ms, Mms )

sdim = length(Vms.mean);

for j = 1:sdim
   
    % From itself:
    %   gme = < exp Vvms > ( <Vms_j> - <Mvms> )
    %   gva = 0.5 <exp Vvms>
    %   gex = 0
    gme = Vvms.mex * ( Vms.mean(j) - Mvms.mean );
    gva = 0.5 * Vvms.mex;
    gex = 0;
    
    % From children ms:
    %          
    %   gme = sum -0.5
    %          k
    %
    %   gva = sum 0.5 <exp Vms_j>
    %          k
    %
    %   gex = 0
    %
    mixdim = length(ms{j}.mean);
    gme = gme - mixdim/2;
    
    for k = 1:mixdim
        gex = gex + ...
              0.5 * ( ( ms{j}.mean(k) - Mms.mean(j) )^2 +...
                      ms{j}.var(k) + Mms.var(j) );
    end

    [Vms.mean(j), Vms.var(j)] = var_newton( Vms.mean(j),...
                                            Vms.var(j),...
                                            gme, gva, gex );
    
end

Vms.mex  = meanexp( Vms );
