%  UPDATE_VVX.M
%
%  Update the posterior approximation for the variance hyperparameter
%  Vvx of variance parameters vx. Vvx is the variance parent for all
%  the components of vx.
%
function Vvx = update_Vvx( Vvx, Mvx, vx )

xdim = length(vx.mean);

% From itself:
%   gme = < exp 0 > ( <Vvx> - <0> )
%   gva = 0.5 <exp 0>
%   gex = 0
gme = Vvx.mean;
gva = 0.5;
gex = 0;
    
% From children vx:
%          n
%   gme = sum -0.5
%         i=1
%
%   gva = 0
%
%          n
%   gex = sum 0.5 [ ( <vx_i> - <Mvx> )^2 + ~vx_i~ + ~Mvx~ ]
%         i=1
%
gme = gme - xdim/2;
    
for i = 1:xdim
    gex = gex + ...
          0.5 * ( ( vx.mean(i) - Mvx.mean )^2 +...
                  vx.var(i) + Mvx.var );
end

[Vvx.mean, Vvx.var] = var_newton( Vvx.mean, Vvx.var, gme, gva, gex );

Vvx.mex  = meanexp( Vvx );
