%  UPDATE_MOGM.M
%
%  ICA with the mixture-of-Gaussians model for the sources. Update the
%  posterior approximation for the MoG means.
%
function ms = update_mogm( ms, Mms, Vms, s, vs, lambda )

sdim = length(ms);
tdim = length(s);

for j = 1:sdim

    for k = 1:length( ms{j}.mean )
        
        % From itself:
        %   gme = < exp Vms_j > ( <ms_{j,k}> - <Mms_j> )
        %   gva = 0.5 <exp Vms_j>
        %   gex = 0
        gme = Vms.mex(j) * ( ms{j}.mean(k) - Mms.mean(j) );
        gva = 0.5 * Vms.mex(j);
        gex = 0;
        
        % From children s(t):
        %          N
        %   gme = sum lambda_{t,j,k} <exp vs_{j,k}> ...
        %         t=1                ( <ms_{j,k}> - <s_{t,j}> )
        %
        %          N
        %   gva = sum lambda_{t,j,k} 0.5 <exp vs_{j,k}>
        %         t=1
        %
        %   gex = 0
        %
        gme1 = 0;
        for t = 1:tdim
            gme1 = gme1 + lambda{j}(k,t) * ...
                   ( ms{j}.mean(k) - s(t).mean(j) );
        end
        gme = gme + vs{j}.mex(k) * gme1;
        
        gva = gva + 0.5 * vs{j}.mex(k) * sum( lambda{j}(k,:) );
        
        [ms{j}.mean(k), ms{j}.var(k)] = var_newton( ms{j}.mean(k),...
                                                    ms{j}.var(k),...
                                                    gme, gva, gex );
        
    end
end