%  UPDATE_MOGV.M
%
%  ICA with the mixture-of-Gaussians model for the sources. Update the
%  posterior approximation for the MoG variances.
%
function vs = update_mogv( vs, Mvs, Vvs, s, ms, lambda )

sdim = length(vs);
tdim = length(s);

for j = 1:sdim

    for k = 1:length( vs{j}.mean )
        
        % From itself:
        %   gme = < exp Vvs_j > ( <vs_{j,k}> - <Mvs_j> )
        %   gva = 0.5 <exp Vvs_j>
        %   gex = 0
        gme = Vvs.mex(j) * ( vs{j}.mean(k) - Mvs.mean(j) );
        gva = 0.5 * Vvs.mex(j);
        gex = 0;
        
        % From children s(t):
        %               N
        %   gme = -0.5 sum lambda_{t,j,k}
        %              t=1
        %
        %   gva = 0
        %
        %          N
        %   gex = sum  lambda_{t,j,k} 0.5
        %         t=1      [ ( s_{t,j} - <ms_{j,k}> )^2 + 
        %                    ~ms_{j,k}~ + ~s_{t,j}~ ]
        %
        gme = gme - 0.5 * sum( lambda{j}(k,:) );
        for t = 1:tdim
            gex = gex + ...
                  0.5 * lambda{j}(k,t) * ...
                  ( ( s(t).mean(j) - ms{j}.mean(k) )^2 +...
                    ms{j}.var(k) + s(t).covar(j,j) );
        end
        
        [vs{j}.mean(k), vs{j}.var(k)] = var_newton( vs{j}.mean(k),...
                                                    vs{j}.var(k),...
                                                    gme, gva, gex );
    end
    vs{j}.mex = meanexp( vs{j} );
        
end