%  UPDATE_MU.M
%
%  ICA with super-Gaussian sources. Update the posterior approximation for
%  the mean hyperparameter of the variance nodes.
%
function mu = update_mu( mu, Mmu, Vmu, u, vu )

tdim = length(u);
sdim = length(mu.mean);

for j = 1:sdim
    
    % From itself:
    %   gme = < exp Vmu > ( <mu_j> - <Mmu> )
    %   gva = 0.5 <exp Vmu>
    %   gex = 0
    gme = Vmu.mex * ( mu.mean(j) - Mmu.mean );
    gva = 0.5 * Vmu.mex;
    gex = 0;
    
    % From children u:
    %          N
    %   gme = sum <exp vu_j> ( <mu_j> - <u_{t,j}> )
    %         t=1
    %
    %          N
    %   gva = sum 0.5 <exp vu_j> = N * 0.5 <exp vu_j>
    %         t=1
    %
    %   gex = 0
    %
    for t = 1:tdim
        gme = gme + vu.mex(j) * ( mu.mean(j) - u(t).mean(j) );
    end
    gva = gva + tdim * 0.5 * vu.mex(j);
    
    [mu.mean(j), mu.var(j)] = var_newton( mu.mean(j), mu.var(j),...
                                          gme, gva, gex );
end
