%  UPDATE_U.M
%
%  Linear factor analysis model with variance model for the factors.
%  Update the posterior approximation of u.
%
%  Ilin A.N.
%
function u = update_u( u, mu, vu, s )

tdim = length(u);
sdim = length(mu.mean);

%const0.mean = 0;
%const0.var = 0;
%const0.mex = meanexp( const0 );
%disp( 'Before update_u' )
%fprintf( 'cost_u: %f\n', cost_u( u, mu, vu ) )
%fprintf( 'cost_sv: %f\n', cost_sv( s, const0, u, 0 ) )
%fprintf( 'cost total: %f\n', ...
%         cost_u( u, mu, vu ) + cost_sv( s, const0, u, 0 ) )

for t = 1:tdim
    for j = 1:sdim
        
        % From itself:
        %   gme = < exp vu_j > ( <u_{t,j}> - <mu_j> )
        %   gva = 0.5 <exp vu_j>
        %   gex = 0
        gme = vu.mex(j) * ( u(t).mean(j) - mu.mean(j) );
        gva = 0.5 * vu.mex(j);
        gex = 0;
        
        % From children s:
        % 
        %   gme = -0.5
        %
        %   gva = 0
        %
        %   gex = 0.5 [ <S_{t,j}>^2 + ~S_{t,j}~ ]
        %
        gme = gme - 0.5;
        
        gex = gex + 0.5 * ( s(t).mean(j)^2 + s(t).covar(j,j) );
        
        [u(t).mean(j), u(t).var(j)] = ...
            var_newton( u(t).mean(j), u(t).var(j), gme, gva, gex );
        
    end
    u(t).mex  = meanexp( u(t) );
end

%disp( 'After update_u' )
%fprintf( 'cost_u: %f\n', cost_u( u, mu, vu ) )
%fprintf( 'cost_s_full: %f\n', cost_sv( s, const0, u, 0 ) )
%fprintf( 'cost total: %f\n', ...
%         cost_u( u, mu, vu ) + cost_sv( s, const0, u, 0 ) )

return

