%  UPDATE_VS.M
%
%  Static model for linear factor analysis.
%  Update the posterior approximation of vs.
%
%  Ilin A.N.
%
function vs = update_vs( vs, Mvs, Vvs, s )

tdim = length(s);
sdim = length(vs.mean);

for j = 1:sdim
    
    % From itself:
    %   gme = < exp Vvs > ( <vs_j> - <Mvs> )
    %   gva = 0.5 <exp Vvs>
    %   gex = 0
    gme = Vvs.mex * ( vs.mean(j) - Mvs.mean );
    gva = 0.5 * Vvs.mex;
    gex = 0;
    
    % From children s:
    %          N
    %   gme = sum -0.5
    %         t=1
    %
    %   gva = 0
    %
    %          N
    %   gex = sum 0.5 [ <S_{t,j}>^2 + ~S_{t,j}~ ]
    %         t=1
    %
    gme = gme - tdim/2;
    
    for t = 1:tdim
        gex = gex + ...
              0.5 * ( s(t).mean(j)^2 + s(t).covar(j,j) );
    end
    
    [vs.mean(j), vs.var(j)] = ...
        var_newton( vs.mean(j), vs.var(j), gme, gva, gex );
    
end

vs.mex  = meanexp( vs );
