%  UPDATE_VSD.M
%
%  ICA with temporally correlated sources. Update the posterior
%  approximation for the variance parameter of the source innovation
%  process vs.
%
function vs = update_vsd( vs, Mvs, Vvs, s, B )

tdim = length(s);
sdim = length(vs.mean);

for j = sdim:-1:1
    
    % From itself:
    %   gme = < exp Vvs > ( <vs_j> - <Mvs> )
    %   gva = 0.5 <exp Vvs>
    %   gex = 0
    gme = Vvs.mex * ( vs.mean(j) - Mvs.mean );
    gva = 0.5 * Vvs.mex;
    gex = 0;
    
    % From children s:
    %          N
    %   gme = sum -0.5
    %         t=1
    %
    %   gva = 0
    %
    %          N
    %   gex = sum 0.5 [ ( <S_{t,j}> - <B_{j,:} S_{t-1}> )^2 +
    %         t=1       ~B_{j,:} S_{t-1}~ + ~S_{t,j}~ ]
    %
    gme = gme - (tdim-1)/2;
    
    for t = 2:tdim
        m2_stj = s(t-1).mean(j)^2;
        v_Bs = ( B.mean(j)^2 + B.var(j) ) * ...
               ( m2_stj + s(t-1).covar(j,j) ) - ...
               B.mean(j)^2 * m2_stj;
        gex = gex + ...
              0.5 * ( ...
                  ( s(t).mean(j) - B.mean(j) * s(t-1).mean(j) )^2 +...
                  v_Bs + s(t).covar(j,j) );
    end
    
    [vs.mean(j), vs.var(j)] = ...
        var_newton( vs.mean(j), vs.var(j), gme, gva, gex );
    
end

vs.mex  = meanexp( vs );
