function [ s_mean, s_var ] = var_newton( s_mean, s_var, gme, gva, gex )

EPSILON = 1e-10;
MAXSTEP = 4;
MINSTEP = 1e-4;

if gex == 0
    s_var = 0.5 / gva;
    s_mean = s_mean - s_var * gme;
    
else
    
    old_mean = s_mean;
    old_var = s_var;
    old_cost = cost( s_mean, s_var, old_mean, gva, gme, gex );
    mstep = MINSTEP+1;
    vstep = 0;
    
    i = 0;
    while abs(mstep) > MINSTEP | abs(vstep) > MINSTEP

        mstep = -( gme + 2*gva*( s_mean - old_mean ) + ...
                   gex * exp( s_mean + s_var/2 ) ) /...
                ( 2*gva + gex * exp( s_mean + s_var/2 ) );

        if mstep > MAXSTEP
            s_mean = s_mean + MAXSTEP;
        else
            s_mean = s_mean + mstep;
        end
        
        vstep = 1 / ( 2*gva + gex * exp( s_mean + s_var/2 ) ) - s_var;
        coef = s_var * ( 0.5 - gva * s_var );
        if coef > 0
            vstep = vstep / ( 1 + coef );
        end
        
        if vstep > MAXSTEP
            s_var = s_var + MAXSTEP;
        else
            s_var = s_var + vstep;
        end

        i = i + 1;
        if i >= 100
            warning( 'VarNewton: Optimization problems 1' )
            break
        end
    end
    
    new_cost = cost( s_mean, s_var, old_mean, gva, gme, gex );

    if new_cost - EPSILON > old_cost
        warning( 'VarNewton: Optimization problems 2' )
    end
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function cf = cost( s_mean, s_var, old_mean, gva, gme, gex )

cf = gex * exp( s_mean + s_var/2 ) + gme * s_mean + ...
     gva * ( ( s_mean - old_mean )^2 + s_var ) - 0.5 * log(s_var);