%  Experiments on the effect of the posterior approximation
%   reported in the paper submitted to Neural Processing Letters.
%
%  Plot the results reported in the paper:
%   
%   nplfigures    - Plot figures of the NPL paper
%   
%  Data generation:
%
%   gendyn        - Generate linear mixture of sources with dynamics
%   gensg         - Generate linear mixture of super-Gaussian sources
%
%  General linear factor analysis model:
%
%   meanexp       - Calculate the expected value of the exponent of a
%                   Gaussian variable
%
%   update_A      - Update for the mixing matrix A
%   update_vx     - Update for the observation noise parameter vx
%   update_Mvx    - Update for the mean of variance parameters
%   update_Vvx    - Update for the variance of variance parameters
%
%   cost_gauss    - Cost of a Gaussian variable
%   cost_gauss_2  - Cost of a Gaussian variable
%                   (the same variance v for every row of s)
%   cost_x        - Cost of observed Gaussian variables
%   cost_x1       - Cost of observed Gaussian variables
%                   (equal covariance matrices for all s(t))
%
%
%  Plotting the results:
%
%   res_track     - Plot the trajectory of the mixing matrix A for
%                   results obtained with different initialisations of
%                   A
%
%
%  1. VB ICA with temporally correlated sources
%  --------------------------------------------
%
%   dynica        - Create, initialize and learn the ICA model
%   run_dynica    - Run the simulations with DYNICA
%   cnt_dynica    - Continue the simulations with DYNICA
%   dynica2net    - Save model variables as a structure
%   net2dynica    - Load model variables from the structure
%
%  Specific update functions:
%
%   update_sd     - Update for the sources s
%   update_B      - Update for the matrix B of source dynamics
%   update_vsd    - Update for the variance parameter of the source
%                   innovation
%
%  Cost function evaluation:
%
%   cost_dynica   - Total cost for the model
%   cost_sd       - Cost of the sources
%
%
%  2. VB ICA with super-Gaussian sources
%  -------------------------------------
%
%   sgica         - Create, initialize and learn the ICA model
%   run_sgica     - Run the simulations with SGICA
%   cnt_sgica     - Continue the simulations with SGICA
%   sgica2net     - Save model variables as a structure
%   net2sgica     - Load model variables from the structure
%
%  Specific update functions:
%
%   update_sv     - Update for the sources s
%   update_mu     - Update for the mean of the variance nodes
%   update_vu     - Update for the variance of the variance nodes
%
%  Cost function evaluation:
%
%   cost_sgica    - Total cost for the model
%   cost_u        - Cost of the variance nodes
%   cost_sv       - Cost of the sources
%
%
%  3. VB ICA with mixture-of-Gaussians model for sources
%  -----------------------------------------------------
%
%   mogica        - Create, initialize and learn the ICA model
%   run_mogica    - Run the simulations with MOGICA
%   cnt_mogica    - Continue the simulations with MOGICA
%   mogica2net    - Save model variables as a structure
%   net2mogica    - Load model variables from the structure
%   explog_pi     - Calculate the expected value of the
%                   logarithm of a Dirichlet variable
%
%  Specific update functions:
%
%   update_sica   - Update for the sources s
%   update_mogc   - Update for the MoG coefficients
%   update_mogm   - Update for the MoG means
%   update_mogv   - Update for the MoG variances
%   update_lambda - Update for the approximating coefficents lambda
%   update_Mms    - Update for the mean of parameters of MoG prior
%   update_Vms    - Update for the variance of parameters of MoG prior
%
%

%  Alexander Ilin