%  COST_DYNICA.M
%
%  Calculate the cost function for the ICA model with temporally
%  correlated sources.
%
function C = cost_dynica( x, A, s, vx, Vvx, Mvx,...
                          B, vs, Mvs, Vvs, diag_qs )

if nargin < 14 | isempty(diag_qs)
    diag_qs = 0;
end

const0.mean = 0;
const0.var = 0;
const0.mex = meanexp( const0 );

C = cost_gauss( Mvx, const0, const0 ) +...
    cost_gauss( Vvx, const0, const0 ) +...
    cost_gauss( vx, Mvx, Vvx ) +...
    cost_gauss( B, const0, const0 ) +...
    cost_gauss( A, const0, const0 ) +...
    cost_gauss( Mvs, const0, const0 ) +...
    cost_gauss( Vvs, const0, const0 ) +...
    cost_gauss( vs, Mvs, Vvs ) +...
    cost_sd( s, B, vs, diag_qs ) +...
    cost_x( x, A, s, vx, diag_qs );

return

