%  COST_X1.M
%
%  The cost corresponding to observed Gaussian variables x. The prior
%  mean for the observations is calculated from x = A*s.
%  The posterior covariance matrix of s(t) is equal for all t.
%
function C = cost_x1( x, A, s, vx, diag_qs )

C = 0;
tdim = length(x);
xdim = length(x(1).value);

if ~diag_qs
    for t = 1:tdim
        f_mean = A.mean * s.mean(:,t);
        for i = 1:xdim
            f_var(i,1) = A.mean(i,:) * s.covar * A.mean(i,:)' + ...
                A.var(i,:) * ( s.mean(:,t).^2 + diag( s.covar ) );
        end
        C = C ...
            + 0.5 * xdim * log(2*pi) - 0.5 * sum( vx.mean ) ...
            + 0.5 * sum( ...
                vx.mex .* ...
                ( ( x(t).value - f_mean ).^2 + f_var ) );
    end

else
    for t = 1:tdim
        f_mean = A.mean * s.mean(:,t);
        f_var = ( A.mean.^2 + A.var ) * ...
                ( s.mean(:,t).^2 + diag( s.covar ) ) - ...
                A.mean.^2 * s.mean(:,t).^2;
        C = C ...
            + 0.5 * xdim * log(2*pi) - 0.5 * sum( vx.mean ) ...
            + 0.5 * sum( ...
                vx.mex .* ...
                ( ( x(t).value - f_mean ).^2 + f_var ) );
    end
end
