function h = plot_mogifa( netfile, ifa )

if nargin < 2
    ifa = 0;
end
if ifa
    load( [ ilindir '/fa/' netfile ], 'net', 'net_end' )

    M = net{end}.ms;
    V = exp( -net{end}.vs );
    C = net{end}.diri;
else
    load( [ ilindir '/fa/' netfile ], 'net' )

    for j = 1:length(net{end}.ms)
        M(j,:) = net{end}.ms{j}.mean';
        V(j,:) = exp( -net{end}.vs{j}.mean' );
        C(j,:) = net{end}.mog_pi{j}.mean';
    end
end    

M
V
C
    
ndim = size(M,1);
sp = sbplots(ndim);

for i = 1:ndim
    %figure(1)
    subplot( sp(1), sp(2), i )
    
    xlim(1) = min( M(i,:) - 3*sqrt(V(i,:)) );
    xlim(2) = max( M(i,:) + 3*sqrt(V(i,:)) );
    
    x = linspace( xlim(1), xlim(2), 500 );
    [ pt, p ] = mogpdf( x, M(i,:), V(i,:), C(i,:) );
    hold off
    h(i) = plot( x, pt );
    hold on
    for k = 1:size(p,1)
        %figure
        plot( x, p(k,:), 'r--' )
    end
end

if nargout == 0
    clear h
end
