%  UPDATE_MMS.M
%
%  ICA with the mixture-of-Gaussians model for the sources. Update the
%  posterior approximation for the mean hyperparameter Mms of the
%  paramters ms. Mms is the mean parent for all the components of ms.
%  The components of ms are hyperparameter of the MoG prior for
%  different sources.
%
function Mms = update_Mms( Mms, Mmms, Vmms, ms, Vms )

sdim = length(Mms.mean);

for j = 1:sdim
   
    % From itself:
    %   gme = < exp Vmms > ( <Mms_j> - <Mmms> )
    %   gva = 0.5 <exp Vmms>
    %   gex = 0
    gme = Vmms.mex * ( Mms.mean(j) - Mmms.mean );
    gva = 0.5 * Vmms.mex;
    gex = 0;
    
    % From children ms:
    %          
    %   gme = sum <exp Vms_j> ( <Mms_j> - <ms_{j,k}> )
    %          k
    %
    %   gva = sum 0.5 <exp Vms_j>
    %          k
    %
    %   gex = 0
    %
    mixdim = length(ms{j}.mean);
    gme = gme + Vms.mex(j) * sum( Mms.mean(j) - ms{j}.mean );
    gva = gva + mixdim * 0.5 * Vms.mex(j);
    
    [Mms.mean(j), Mms.var(j)] = var_newton( Mms.mean(j),...
                                            Mms.var(j),...
                                            gme, gva, gex );
    
end
