function [theta_ML, ulpp] = est_ulpp(model,data,N_optim_rounds)

latentLB = [data.lb_lambda1, data.lb_tau1, data.lb_lambda2, data.lb_tau2];
latentUB = [data.ub_lambda1, data.ub_tau1, data.ub_lambda2, data.ub_tau2];
LB = log([data.lb_theta*ones(1,length(model.act_ind_rates)), latentLB(model.act_ind_latent)]);
UB = log([data.ub_theta*ones(1,length(model.act_ind_rates)), latentUB(model.act_ind_latent)]);

% define options for the optimization
OPToptions = optimoptions('lsqnonlin','Jacobian','on','Display','off');

% multistart optimization
THETA = zeros(N_optim_rounds,model.d);
VALUE = zeros(1,N_optim_rounds);
LHS_THETA = lhsdesign(N_optim_rounds,model.d);
for i = 1:N_optim_rounds
    % sample an initial guess within the bounds
    theta0 = LB + (UB -LB).*LHS_THETA(i,:); % LHC sampling
    
    % target function to be minimized to find max lh estimate
    target = @(theta)LSQtarget(theta,model,data);

    % run optimization and keep track of the best value found
    [theta_temp, value_temp] = lsqnonlin(target,theta0,LB,UB,OPToptions);
    THETA(i,:) = theta_temp; VALUE(i) = value_temp;
end

[~, index] = min(VALUE);
theta_ML = THETA(index,:);

% compute the log. maxlh
log_max_lh = log_likelihood(theta_ML,model,data);

% compute the estimate for ulpp
ulpp  = log_max_lh - 0.5*model.d*log(data.number_of_meas) ... % marginal likelihood estimate
          + log( geopdf(sum(sum(model.Z)),data.prior_param) / (sum(geopdf(1:length(model.Z(:)),data.prior_param))) );  % log-prior over models