function [F, J] = LSQtarget_annealed(beta,theta,model,data)

% prior mean and std
m = 0; s = 1;

% proportions of m_e and m_q at time 80 hours, and std for this information
d_mq    = data.d_mq;
d_me    = data.d_me;
sigma_d = data.sigma_d;

log_theta = theta;
theta = exp(theta);

try

D = data.mtot(2:end,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% CVODES initialization
options = CVodeSetOptions('UserData',theta,'JacobianFn',model.djacfn);

t0 = 0;        % init time
tout = data.time(2:end); % time points to be evaluated

% initialize the solver
CVodeInit(model.rhsfn, 'BDF', 'Newton', t0, [data.mtot(1,1) 0 0 1 0]', options);

% FSA initialization
Ns  = model.d; % # of parameters
yS0 = model.R(0,[data.mtot(1,1) 0 0 1 0]',theta); % initial sensitivities, n x d matrix

% user-provided sensitivity RHS
FSAoptions = CVodeSensSetOptions('method','Simultaneous','ErrControl', true);
CVodeSensInit(Ns, model.rhsSfn, yS0, FSAoptions);

% Run solver 
[status, t, y, S] = CVode(tout,'Normal'); % y is n x N_timepoints matrix and S is an n x d x N_timepoints matrix
Y = sum(y(1:3,:))';

% Free memory
CVodeFree;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the standard deviation depends on the signal
SIGMA = data.std(2:end,1);

% compute the squared components of likelihood
F  = [sqrt(beta) * (D - Y) ./ SIGMA; sqrt(beta) * (d_me - (y(2,end) / sum(y(1:3,end))) ) / sigma_d;sqrt(beta) * (d_mq - (y(3,end) / sum(y(1:3,end))) ) / sigma_d; (log_theta' - m) ./ s;]; % objective function values at theta

APU_me = zeros(1,length(theta));
APU_mq = zeros(1,length(theta));

if nargout > 1   % Two output arguments
   J = zeros(length(D),length(theta)); % initialize the Jacobian of the function evaluated at x
   for k = 1:length(theta)
       SENS   = squeeze( S(:,k,:)*theta(k) ); %  multiplication with param. val is for converting linear sensitivities to log-scale sensitivities
       J(:,k) = -( sqrt(beta)./SIGMA) .* sum(SENS(1:3,:))';
       APU_me(k) = sqrt(beta)/sigma_d * ( sum(SENS(1:3,end)) * sum(y(1:3,end))^-2 * y(2,end) - SENS(2,end)*sum(y(1:3,end))^-1);
       APU_mq(k) = sqrt(beta)/sigma_d * ( sum(SENS(1:3,end)) * sum(y(1:3,end))^-2 * y(3,end) - SENS(3,end)*sum(y(1:3,end))^-1);
   end
end

J = [J;APU_me;APU_mq;1/s * eye(length(theta))];

if(sum(sum(isnan(J)))>0 || sum(sum(isinf(J)))>0 || sum(isinf(F))>0 || sum(isnan(F))>0)
    % nan or inf in the solution
    display('Solver crash!')
    F = 10^9*ones(length(D(:))+2+length(theta),1); J = ones(length(D(:))+2+length(theta),length(theta));
end

catch error
    % ode system could not be solved
    display('LSQtarget crash!')
    F = 10^9*ones(length(D(:))+2+length(theta),1); J = ones(length(D(:))+2+length(theta),length(theta));
end

end