function value = logLH(theta,theta_ind,DATA)
theta_lin            = zeros(1,8);
theta_lin(theta_ind) = exp(theta);

% relative proportions of m_e and m_q at time 80 hours, and std for this information
d_mq    = DATA.d_mq;
d_me    = DATA.d_me;
sigma_d = DATA.sigma_d;

try
    % solve the WT response
    [t, X_wt] = ode15s(@(t,X)rhsf_micenv(t,X,theta_lin,1),DATA.time,[DATA.mtot(1,1) 0 0 1 0]);
    % total cell mass
    value     = sum(log(1./(sqrt(2*pi) * DATA.std(2:end,1)))) - 0.5 * sum( ( (DATA.mtot(2:end,1) - sum(X_wt(2:end,1:3),2)) ./ DATA.std(2:end,1) ).^2 ) ...
                + log(1/(sqrt(2*pi) * sigma_d)) - 0.5 * ((d_me - (X_wt(end,2)/ sum(X_wt(end,1:3))) ) / sigma_d ).^2 ...
                + log(1/(sqrt(2*pi) * sigma_d)) - 0.5 * ((d_mq - (X_wt(end,3)/ sum(X_wt(end,1:3))) ) / sigma_d ).^2;
catch
   display('ODE system could not be solved.')
   value = -1e10;
end

end