function theta_opt = ms_optim(beta,model,data,N_optim_rounds)

theta_opt = zeros(length(beta)-1,model.d);

LB = 0.00001*ones(1,model.d);
UB = 100*ones(1,model.d);
LB = log(LB);UB = log(UB);
OPToptions = optimoptions('lsqnonlin','Jacobian','on','Display','off');

for j = 2:length(beta)
    THETA = zeros(N_optim_rounds,model.d);
    VALUE = zeros(1,N_optim_rounds);
    LHS_THETA = lhsdesign(N_optim_rounds,model.d);
    beta_current = beta(j);
    for i = 1:N_optim_rounds
        theta0 = LB + (UB -LB).*LHS_THETA(i,:);
        target = @(theta)LSQtarget_annealed(beta_current,theta,model,data);       
        [theta_temp, value_temp] = lsqnonlin(target,theta0,LB,UB,OPToptions);
        THETA(i,:) = theta_temp; VALUE(i) = value_temp;
    end
    
    [~, index]       = min(VALUE);
    theta_opt(j-1,:) = THETA(index,:);

    disp(['Initial parameters in temperature beta_',num2str(j),' optimized.']);
end