n_chains    = 4;
model_index = 1;
n_beta      = 30;
n_samples   = 2500;

datafile  = 'DATA.mat';
modelfile = 'MODELS.mat';
[parentdir,~,~] = fileparts(pwd);
load(fullfile(parentdir,datafile));
load(fullfile(parentdir,modelfile));
clear datafile; clear modelfile;

compute_psrf(n_chains,n_beta,n_samples,MODELS);
pause; close all;

for i = 1:3
    thetafile = ['theta_map',int2str(i),'.mat'];
    load(fullfile(parentdir,thetafile)); clear thetafile;
    run_post_analysis(n_chains,i,n_beta,n_samples,DATA,MODELS,theta);
end
clear parentdir;

for i = 1:3
    show_post_analysis_result(n_chains,i,n_beta,DATA,MODELS);
    pause; close all;
end

LOGMLH = zeros(1,3);
for i = 1:3
    load(['post_analysis_result_m',int2str(i)]);
    LOGMLH(i) = pa_result.log_margLH;
end

figure;
bar(LOGMLH);
LOGMLH
xticks([1 2 3])
xticklabels({'H_1','H_2','H_3'});
ylabel('log(marg. likelihood)');

figure;
bar(exp(LOGMLH)/sum(exp(LOGMLH)));
exp(LOGMLH)/sum(exp(LOGMLH))
xticks([1 2 3])
xticklabels({'H_1','H_2','H_3'});
ylabel('Probability');
xlabel('Hypothesis');