function [fp_area, dT] = main_spatial(p,T,growth_on_e,subsamp_interval,save_interval)

% subsampling interval for the footprint area
dT = 0.5;

lambda_colony = exp(p(1));
lambda_agar   = exp(p(2));
agar_g_init   = 1;

display('Initializing a simulation with');
display(['  lambda_colony = ',num2str(lambda_colony)]);
display(['  lambda_agar = ',num2str(lambda_agar)]);
display(['  agar_g_init = ',num2str(agar_g_init)]);
display(['  growth_on_e = ',num2str(growth_on_e)]);
display('...');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialize the parameters for the simulation

%graphics = true;
graphics = false;

%%%%%%%%%%%%%%%%%%%%%%%
% specify the name for the result file
if(growth_on_e==0)
    run_name = 'colony_petite';
else
    run_name = 'colony_wt';
end

%%%%%%%%%%%%%%%%%%%%%%%
% microenvironment params
model_ind = 2; load theta_map2; load MODELS;
theta_temp = zeros(1,8);
theta_temp(MODELS{model_ind})  = exp(theta);
theta_micenv.theta             = theta_temp;
theta_micenv.growth_on_ethanol = growth_on_e; % strain information (wt = 1 or pet = 0)

%%%%%%%%%%%%%%%%%%%%%%%
% spatial model params
theta_spatial.mg_init       = 1;
theta_spatial.lambda_mass   = 20;
theta_spatial.th_mass       = 1;
theta_spatial.lambda_colony = lambda_colony;
theta_spatial.lambda_agar   = lambda_agar;

%%%%%%%%%%%%%%%%%%%%%%%
% grid params
grid.h          = 0.1; % grid resolution, elementary cubes will be h x h x h
grid.max_rad    = 5;
grid.max_height = 2.5;

%%%%%%%%%%%%%%%%%%%%%%%
% agar params
agar.gluc_init  = agar_g_init;
agar.h          = 2; % thickness of the agar (the # of elem. cubes)

%%%%%%%%%%%%%%%%%%%%%%%
% simulation params
sim_params.T                     = T;
sim_params.dt                    = 0.0025; %0.00125;
sim_params.subsamp_interval      = subsamp_interval;
sim_params.subsamp_area_interval = dT;
sim_params.illustrate_interval   = 5;
sim_params.save_interval         = save_interval;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% run the simulation
display('Simulation initialized.');
try
    [fp_area, ~] = colsim(sim_params,grid,theta_micenv,theta_spatial,agar,run_name,graphics);
catch
    display('Not able to evaluate y using the parameter combination.');
    fp_area = zeros(1,length(sim_params.subsamp_interval:sim_params.subsamp_interval:T));
    %time = zeros(1,length(sim_params.subsamp_interval:sim_params.subsamp_interval:T));
end
