function run_lhs(run_index)

rng('default');
N = 20;
name = ['lhsamp_',int2str(run_index)];

disp(name)

d     = 2;
LHS_P = lhsdesign(N,d);
P     = zeros(d,N);
LB = [log(0.005) log(5)];
UB = [log(1)     log(75)];
for i = 1:N
    P(:,i)    = (LB + (UB - LB).* LHS_P(i,:))';
end

%scatter(P(1,:),P(2,:))

T = 194;
p = P(:,run_index);
growth_on_e      = 1;
subsamp_interval = 18;
save_interval    = T + 1;
p
[fp_area, dT]    = main_spatial(p,T,growth_on_e,subsamp_interval,save_interval);
save(name,'fp_area','dT','T','p');