%% A7_main
% is a function to run a single chain MCMC sampling locally, for all 24 alternative models, given all data files.
% This takes around 1-3 minutes to run a chain of 200,000 samples.
% Readers can simply run this function to generate MCMC chains.
% There is a 'pause' between each sampling and please press any key to continue.

%% experimental data
for M = 1:8     % wiring model that draw samples from
    for H = 1:3 % hypothesis   that draw samples from
        
        output = A6_local_run(M,H , 0,0,[]); % MCMC
        drawnow;   % draw figure now
        pause;     % pause between each chain
        close all; % close the figure window
        
    end
end

%% simulated data
for M = 1:8                      % wiring model that draw samples from
    for H = 1:3                  % hypothesis   that draw samples from
        for M_simu = 1:8         % wiring model that simulates data
            for H_simu = 1:3     % hypothesis   that simulates data
                for repeat = 1:1 % repetition number
                    
                    output = A6_local_run(M,H , M_simu,H_simu,repeat); % MCMC
                    drawnow;   % draw figure now
                    pause;     % pause between each chain
                    close all; % close the figure window
                    
                end
            end
        end
    end
end
