library("lattice")

test <- function() {
  set.seed(2)
  path <- "/triton/ics/work/eleppaah/scripts/"
  source("sparseGFAdual.R")
  while(dev.cur()>1)
    dev.off()
  par(mfrow=c(1,2), oma=c(0,0,0,0))
  
  #Generate the toy data, store the dimensions of the view sets
  toy <- genData()
  D1 <- cumsum(toy$D[[1]])
  D2 <- cumsum(toy$D[[2]])
  
  #Plot true bicluster-components
  Y <- list()
  for(v in 1:2) {
    for(k in 1:toy$K[v]) {
      Y[[length(Y)+1]] <- tcrossprod(toy$X[[v]][,k],toy$W[[v]][,k])
    }
  }
  X <- showComp(Y,"",D1,D2,count=1)
  
  #Run the model
  opts <- getDefaultOpts()
  opts$normalLatents <- FALSE
  opts$iter.max <- 3000
  opts$iter.burnin <- 2000
  opts$iter.saved <- 100
  opts$save.posterior <- list(X=TRUE,W=TRUE)
  opts$ARDW <- "grouped"
  res <- gibbsgfa(toy$y,K=c(5,5),opts=opts)
  
  #Plot the inferred components
  Y <- list()
  for(v in 1:2) {
    for(k in 1:res$K[v]) {
      X <- matrix(0,nrow(res$X[[v]]),nrow(res$W[[v]]))
      for(i in 1:opts$iter.saved)
        X <- X + tcrossprod(res$posterior$X[[v]][i,,k], res$posterior$W[[v]][i,,k])
      Y[[length(Y)+1]] <- X/opts$iter.saved
    }
  }
  X <- showComp(Y,"",D1,D2,count=2)

  
  #Predict some things
  #Note that predicting with training data, only for testing purposes
  if(FALSE) {
    opts$iter.max <- 20
    opts$iter.burnin <- 10
    opts$iter.saved <- 5
    opts$prediction <- list(c(FALSE,TRUE,TRUE),c(FALSE,FALSE))
    #Prediction in the fist view set tested and working
    
    predY <- predictGibbsGFA(Y=toy$y, model=res, opts=opts)
    
    #Prediction in mode 1 (views 2 and 3), concatenated with 0-matrix for view 1
    Y <- cbind(matrix(0,toy$N[1],toy$D[[1]][1]),predY[[1]][[2]],predY[[1]][[3]])
    y <- do.call(cbind,toy$y[[1]]) #Real mode 1 data
    Y <- (y^2-(y-Y)^2)/y^2 #Variance explained in mode 1
    count <- showComp(Y,"Variance explained (max 1)",D1,D2,mode=1,count=count)
  }
  #dev.copy(png,"toy2way.png",width=800,height=500)
  #dev.off()
  #print("Saved 'toy2way.png'")
}

genData <- function(joint=F) {
  N <- c(200,100)
  D <- list(c(100,50,60),c(200,70))
  K <- c(2,2)
  Nzero <- list(list(1:100,81:200),list(1:50,51:100))
  Dzero <- list(list(1:100,c(1:30,151:210)),list(1:200,c(1:140,250:270)))
  
  Y <- y <- X <- W <- list()
  for(v in 1:2) {
    X[[v]] <- matrix(rnorm(N[v]*K[v]),N[v],K[v])
    W[[v]] <- matrix(rnorm(sum(D[[v]]*K[v])),sum(D[[v]]),K[v])
    #Limit range
    S <- matrix(c(-Inf,-2,-1,0,0,1,2,Inf),2)
    for(i in 1:ncol(S)) {
      r <- S[c(2,1,2,1)[i],i]
      X[[v]][which(X[[v]]>S[1,i] & X[[v]]<S[2,i])] <- r
      W[[v]][which(W[[v]]>S[1,i] & W[[v]]<S[2,i])] <- r
    }
    for(k in 1:K[v]) { #Sparsity
      X[[v]][Nzero[[v]][[k]],k] <- 0
      W[[v]][Dzero[[v]][[k]],k] <- 0
    }
    if(joint & v==2) {
      X[[2]][,3] <- W[[1]][1:N[2],3]
      W[[2]][1:N[1],3] <- X[[1]][,3]
    }
    Y[[v]] <- tcrossprod(X[[v]],W[[v]]) + matrix(rnorm(N[v]*sum(D[[v]])),N[v],sum(D[[v]]))
    y[[v]] <- list()
    d <- 0
    for(m in 1:length(D[[v]])) {
      y[[v]][[m]] <- Y[[v]][,1:D[[v]][m]+d]
      if(v==2) { #Effect of both component sets to the shared view
        kk <- 1:K[v]
        if(joint)
          kk <- 1:2
        y[[2]][[1]] <- t(y[[1]][[1]]) + tcrossprod(X[[v]][,kk],W[[v]][1:D[[2]][1],kk])
        y[[1]][[1]] <- t(y[[2]][[1]])
      }
      d <- d + D[[v]][m]
    }
  }
  return(list(y=y,Y=Y,X=X,W=W,N=N,D=D,K=K))
}

showComp <- function(Y,main,D1,D2,count) {
  K <- length(Y)
  if(count==2 & K==4) { #Reordering
    X <- Y[[3]]
    Y[[3]] <- Y[[4]]
    Y[[4]] <- X
  }
  X <- matrix(NA,max(D2)*K,max(D1)*K)
  for(k in 1:K) {
    N <- nrow(Y[[k]])
    D <- ncol(Y[[k]])
    x <- abs(Y[[k]])+k*10
    x[which(x==k*10)] <- NA
    #browser()
    if(N==D2[1])
      X[seq(k,N*K,by=K),seq(k,D*K,by=K)] <- x
    else
      X[seq(k,D*K,by=K),seq(k,N*K,by=K)] <- t(x)
  }
  print(paste0("Max value=",round(max(X,na.rm=T)%%10,1)))
  for(i in 1:(nrow(X)/K)) {
    for(j in 1:(ncol(X)/K)) {
      id1 <- ((i-1)*K+1):(i*K)
      id2 <- ((j-1)*K+1):(j*K)
      x <- X[id1,id2]
      y <- unique(x)
      y <- y[!is.na(y)]
      if(length(y)==1) {
        X[id1,id2] <- y
      } else if(length(y)>1) {
        x[,] <- sample(y,K^2,replace=TRUE,prob=y%%10)
        X[id1,id2] <- x
      }
      #if(sum(!is.na(x))==1)
      #  X[id1,id2] <- x[!is.na(x)]
    }
  }
  X[is.na(X)] <- 10 #Base level (gray)
  X[-1:-(D2[1]*K),-1:-(D1[1]*K)] <- NA #Top right white (no data)
  
  #Separate the data sets
  s <- 20 #Whitespace
  Y <- X[1:(D2[1]*K),1:(D1[1]*K)]
  for(i in 2:length(D1))
    Y <- cbind(Y,Y <- matrix(NA,D2[1]*K,s),X[1:(D2[1]*K),(D1[i-1]*K+1):(D1[i]*K)])
  Y <- rbind(Y,matrix(NA,(D2[2]-D2[1])*K+s,ncol(Y)))
  Y[(D2[1]*K+1):(D2[2]*K)+s,1:(D1[1]*K)] <- X[(D2[1]*K+1):(D2[2]*K),1:(D1[1]*K)]
  
  cols <- colorRampPalette(c("grey","red","red","grey","blue","blue","grey","green","green","grey","orange","orange","gray"))
  at <- c()
  for(k in 1:K)
    at <- c(at,seq(0,6,length=100)+k*10)
  at <- c(at,(K+1)*10)
  print(levelplot(t(Y),col.regions=cols,at=at,xlab="",ylab="",main=main,colorkey=F,
                  scales=list(x=list(at=c()),y=list(at=c())),par.settings=list(axis.line=list(col="transparent"))),
        split=c(count,1,2,1),more=TRUE)
  return(X)
}



