function [bss, bps] = choose_parents_from_vertex_cover(scores, N1)
% Finds for each variable not in N1 the best parent set from N1
% 
% Input:
% scores	Local scores
% N1		Vertex cover
%
% Output:
% bss		Scores for the best parent set in N1
% bps		The best parent set in N1

n = length(scores(:, 1));
k = length(N1);
base_set = setdiff(1:n, N1);

bss = -Inf*ones(n - k, 1);
bps = -Inf*ones(n - k, 1);

for i = 1:2^k
    bits = bitget(i - 1, 1:k);
    vars = N1(find(bits));
    ind = sum(bitset(0, vars, 1)) + 1;
    for j = 1:n - k
       if scores(base_set(j), ind) > bss(j)
           bss(j) = scores(base_set(j), ind);
           bps(j) = ind;
       end
    end
end
